/*
 * Decompiled with CFR 0.152.
 */
package jp.geoark.kagura.sound;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import jp.common.LogPrint;
import sun.applet.AppletAudioClip;

public class SoundPalette {
    HashMap bgms = new HashMap();
    HashMap ses = new HashMap();
    int javaVersion;
    int nowBgm;
    AudioClip nowSe = null;

    public SoundPalette() {
        String javaVersionStr = System.getProperty("java.version");
        this.javaVersion = javaVersionStr.compareTo("1.1.0") < 0 ? 10 : (javaVersionStr.compareTo("1.2.0") < 0 ? 11 : 12);
        System.out.println("javaVersion = " + this.javaVersion);
    }

    boolean loadData(int no, String file, HashMap pool) {
        AudioClip ac = null;
        try {
            switch (this.javaVersion) {
                case 11: {
                    ac = this.newAudioClip4Sun(file);
                    break;
                }
                case 12: {
                    URL urlTarget = this.getClass().getResource(file);
                    LogPrint.setLogPrint((String)("getClass().getResource(file) =  " + this.getClass().getResource(file)), (String)LogPrint.DEBUG);
                    if (urlTarget == null) {
                        String dir = System.getProperty("user.dir");
                        urlTarget = SoundPalette.getURLFromFileOrURLName(file);
                        LogPrint.setLogPrint((String)("urlTarget =  " + urlTarget), (String)LogPrint.DEBUG);
                    }
                    if (no == this.nowBgm && pool == this.bgms) {
                        this.pause();
                    }
                    ac = Applet.newAudioClip(urlTarget);
                }
            }
        }
        catch (Exception e) {
            LogPrint.setLogPrint((String)"Warning : SoundPalette is unplayable.", (String)LogPrint.ERR);
            LogPrint.setLogPrint((String)("java.version : " + System.getProperty("java.version")), (String)LogPrint.ERR);
            LogPrint.setLogPrint((String)("java.vendor : " + System.getProperty("java.vendor")), (String)LogPrint.ERR);
            e.printStackTrace();
        }
        if (ac == null) {
            return false;
        }
        pool.put(new Integer(no), ac);
        return true;
    }

    AudioClip newAudioClip4Sun(String file) {
        AppletAudioClip ret;
        try {
            Class.forName("sun.applet.AppletAudioClip");
            ret = new AppletAudioClip(this.getClass().getResource(file));
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public boolean addBgm(int no, String file) {
        return this.loadData(no, file, this.bgms);
    }

    public boolean addSe(int no, String file) {
        return this.loadData(no, file, this.ses);
    }

    AudioClip getAudioClip(int no, HashMap pool) {
        AudioClip ac = null;
        ac = (AudioClip)pool.get(new Integer(no));
        return ac;
    }

    public boolean pause() {
        AudioClip ac = this.getAudioClip(this.nowBgm, this.bgms);
        if (ac == null) {
            return false;
        }
        ac.stop();
        return true;
    }

    public boolean restart() {
        AudioClip ac = this.getAudioClip(this.nowBgm, this.bgms);
        if (ac == null) {
            return false;
        }
        ac.loop();
        return true;
    }

    public boolean playBgm(int no) {
        AudioClip ac = this.getAudioClip(this.nowBgm, this.bgms);
        if (ac != null) {
            ac.stop();
        }
        this.nowBgm = no;
        ac = this.getAudioClip(this.nowBgm, this.bgms);
        if (ac == null) {
            return false;
        }
        ac.loop();
        return true;
    }

    public boolean playSe(int no) {
        if (this.nowSe != null) {
            this.nowSe.stop();
        }
        this.nowSe = this.getAudioClip(no, this.ses);
        if (this.nowSe == null) {
            return false;
        }
        this.nowSe.play();
        return true;
    }

    public static URL getURLFromFileOrURLName(String name) {
        try {
            return new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                char sep = File.separator.charAt(0);
                String file = name.replace(sep, '/');
                if (file.charAt(0) != '/') {
                    String dir = System.getProperty("user.dir");
                    if ((dir = String.valueOf(dir.replace(sep, '/')) + '/').charAt(0) != '/') {
                        dir = "/" + dir;
                    }
                    file = String.valueOf(dir) + file;
                }
                return new URL("file", "", file);
            }
            catch (MalformedURLException e) {
                throw new InternalError("can't convert from filename");
            }
        }
    }
}

