/*
 * Decompiled with CFR 0.152.
 */
package jp.common.info;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jp.common.JpDetailBean;
import jp.common.ProxyUnit;
import jp.common.UnitBaseImpl;
import jp.common.UnitDetailBean;
import jp.common.info.UnitInfoData;
import jp.common.jplink.jplink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitInformation {
    private HashMap<String, UnitInfoData> hashInfoData = new HashMap();
    public final String NAME = "INFO_NAME";
    public final String VERSION = "INFO_VERSION";
    public final String CREATOR = "INFO_CREATOR";
    public final String SINCE = "INFO_SINCE";
    public final String UNIT_PATH = "INFO_UNIT_PATH";
    public final String THIS_UNIT_NAME = "INFO_THIS_UNIT_NAME";
    public final String MY_JP_PATH = "INFO_MY_JP_PATH";
    public final String PARENT_JP_PATH = "INFO_PARENT_JP_PATH";
    public final String CONNECTION = "INFO_CONNECTION";
    public final String PROXY_COUNT = "INFO_PROXY_COUNT";
    public final String UNIT_LISTENER = "INFO_UNIT_LISTENER";
    public final String METHOD = "INFO_METHOD";
    public final String JS_FUNCTION = "INFO_JS_FUNCTION";
    public final String CHILD_UNIT = "CHILD_UNIT";
    public final String[] defalu_keys = new String[]{"INFO_NAME", "INFO_VERSION", "INFO_CREATOR", "INFO_SINCE", "INFO_UNIT_PATH", "INFO_THIS_UNIT_NAME", "INFO_MY_JP_PATH", "INFO_PARENT_JP_PATH", "INFO_CONNECTION", "INFO_PROXY_COUNT", "CHILD_UNIT", "INFO_UNIT_LISTENER", "INFO_METHOD", "INFO_JS_FUNCTION"};
    public final String JP_LENGTH_01 = "JpWordCanma";
    public final String JP_BIFORE_LENGTH_01 = ",";
    public final String JP_LENGTH_02 = "JpWordSeparator";
    public final String JP_BIFORE_LENGTH_02 = ":";
    private String strProxyPath = "";
    private String strTreePath = null;

    public String getTreePath() {
        return this.strTreePath;
    }

    public void setTreePath(String strTmp) {
        this.strTreePath = strTmp;
    }

    public String getProxyPath() {
        return this.strProxyPath;
    }

    public void setProxyPath(String strTmp) {
        this.strProxyPath = strTmp;
    }

    public UnitInformation(UnitBaseImpl UbcTemp) {
        UnitDetailBean Udb = JpDetailBean.getUnitDetail(UbcTemp);
        this.strTreePath = "jp." + Udb.getString("MyJpPath");
        this.initInformation(UbcTemp);
    }

    public UnitInformation(UnitBaseImpl UbcTemp, String strProxyPathTemp) {
        UnitDetailBean Udb = JpDetailBean.getUnitDetail(UbcTemp);
        this.strTreePath = "jp." + Udb.getString("MyJpPath");
        this.strProxyPath = strProxyPathTemp;
        this.initInformation(UbcTemp);
    }

    public UnitInformation(String strInformation, boolean blnProxy) {
        this.initInformation(strInformation, blnProxy);
    }

    public String getInfoFirstValue(String strType) {
        String strValue = "";
        UnitInfoData infoData = this.hashInfoData.get(strType);
        if (infoData != null) {
            return infoData.getDataList().get(0);
        }
        return strValue;
    }

    private void initInformation(String strInformation, boolean blnProxy) {
        String[] strInfos = strInformation.split(",");
        HashMap<String, UnitInfoData> tmpMap = new HashMap<String, UnitInfoData>();
        int intCount = 0;
        while (intCount < strInfos.length) {
            String strInfo = strInfos[intCount];
            String[] strInfoRow = strInfo.split(":");
            if (strInfoRow.length >= 2) {
                UnitInfoData infoData;
                String strDataType = strInfoRow[0];
                if (blnProxy) {
                    if (!"INFO_PROXY_COUNT".equals(strDataType)) {
                        if (tmpMap.get(strDataType) == null) {
                            infoData = new UnitInfoData(strDataType);
                            infoData.setTitle(this.getTitle(strDataType));
                        } else {
                            infoData = (UnitInfoData)tmpMap.get(strDataType);
                        }
                        infoData.add(this.getBefer(strInfoRow[1]));
                        tmpMap.put(strDataType, infoData);
                    }
                } else {
                    if (tmpMap.get(strDataType) == null) {
                        infoData = new UnitInfoData(strDataType);
                        infoData.setTitle(this.getTitle(strDataType));
                    } else {
                        infoData = (UnitInfoData)tmpMap.get(strDataType);
                    }
                    infoData.add(this.getBefer(strInfoRow[1]));
                    tmpMap.put(strDataType, infoData);
                }
            }
            ++intCount;
        }
        Set set = tmpMap.keySet();
        for (String strobject : set) {
            this.setUnitInfoData((UnitInfoData)tmpMap.get(strobject));
        }
    }

    public String getInformation() {
        String strInformation = "";
        boolean first = true;
        for (UnitInfoData info : this.getInfoData()) {
            String strType = info.getInfoType();
            for (String strValue : info.getDataList()) {
                if (!first) {
                    strInformation = String.valueOf(strInformation) + ",";
                }
                strInformation = "INFO_METHOD".equals(strType) && !"".equals(this.strProxyPath) ? String.valueOf(strInformation) + strType + ":" + this.getAfter(strValue).replaceAll(this.strTreePath, this.strProxyPath) : String.valueOf(strInformation) + strType + ":" + this.getAfter(strValue);
                first = false;
            }
        }
        return strInformation;
    }

    private String getAfter(String strWord) {
        strWord = strWord.replaceAll(",", "JpWordCanma");
        strWord = strWord.replaceAll(":", "JpWordSeparator");
        return strWord;
    }

    private String getBefer(String strWord) {
        strWord = strWord.replaceAll("JpWordCanma", ",");
        strWord = strWord.replaceAll("JpWordSeparator", ":");
        return strWord;
    }

    public String getTitle(String strType) {
        if (strType.equals("INFO_NAME")) {
            return "Unit\u540d";
        }
        if (strType.equals("INFO_VERSION")) {
            return "\u30d0\u30fc\u30b8\u30e7\u30f3";
        }
        if (strType.equals("INFO_CREATOR")) {
            return "Creator";
        }
        if (strType.equals("INFO_SINCE")) {
            return "Since";
        }
        if (strType.equals("INFO_UNIT_PATH")) {
            return "Unit\u30d1\u30b9";
        }
        if (strType.equals("INFO_THIS_UNIT_NAME")) {
            return "ThisUnitName";
        }
        if (strType.equals("INFO_MY_JP_PATH")) {
            return "MyJpPath";
        }
        if (strType.equals("INFO_PARENT_JP_PATH")) {
            return "ParentJpPath";
        }
        if (strType.equals("INFO_CONNECTION")) {
            return "\u30b3\u30cd\u30af\u30b7\u30e7\u30f3";
        }
        if (strType.equals("INFO_UNIT_LISTENER")) {
            return "\u51e6\u7406\u4ed8\u304d\u5909\u6570";
        }
        if (strType.equals("INFO_METHOD")) {
            return "\u516c\u958b\u30e1\u30bd\u30c3\u30c9";
        }
        if (strType.equals("INFO_JS_FUNCTION")) {
            return "\u516c\u958b\u30d5\u30a1\u30f3\u30af\u30b7\u30e7\u30f3";
        }
        if (strType.equals("CHILD_UNIT")) {
            return "\u4e0b\u5c64\u30e6\u30cb\u30c3\u30c8";
        }
        if (strType.equals("INFO_PROXY_COUNT")) {
            return "ProxyUnit\u6570";
        }
        return strType;
    }

    private void initInformation(UnitBaseImpl unit) {
        if (unit != null) {
            String strCreator;
            UnitDetailBean Udb = JpDetailBean.getUnitDetail(unit);
            String strName = null;
            if (Udb.getString("UnitName") != null) {
                strName = Udb.getString("UnitName");
                this.setUnitInfoData("INFO_NAME", strName);
            }
            String strVersion = null;
            if (Udb.getString("version") != null) {
                strVersion = Udb.getString("version");
                this.setUnitInfoData("INFO_VERSION", strVersion);
            }
            if (Udb.getString("creator") != null) {
                strCreator = Udb.getString("creator");
                this.setUnitInfoData("INFO_CREATOR", strCreator);
            }
            if (Udb.getString("since") != null) {
                strCreator = Udb.getString("since");
                this.setUnitInfoData("INFO_SINCE", strCreator);
            }
            this.setUnitInfoData("INFO_UNIT_PATH", this.strTreePath);
            this.setUnitInfoData("INFO_THIS_UNIT_NAME", JpDetailBean.getUnitName(unit));
            this.setUnitInfoData("INFO_MY_JP_PATH", Udb.getString("MyJpPath"));
            this.setUnitInfoData("INFO_PARENT_JP_PATH", Udb.getString("ParentJpPath"));
            if (Udb.getString("ProxyCount") != null) {
                this.setUnitInfoData("INFO_PROXY_COUNT", Udb.getString("ProxyCount"));
            }
            this.addUnitLIstenerInformation(Udb);
            this.addUnitMethodInformation(unit);
            this.addChildUnitInformation(unit);
        }
    }

    public void addConnectionInformation() {
        this.remove("INFO_CONNECTION");
        UnitInfoData infoData = new UnitInfoData("INFO_CONNECTION");
        infoData.setTitle(this.getTitle("INFO_CONNECTION"));
        int i = 0;
        while (i < jplink.size()) {
            infoData.add(jplink.get(i));
            ++i;
        }
        this.setUnitInfoData(infoData);
    }

    public void addUnitLIstenerInformation(UnitDetailBean Udb) {
        UnitInfoData infoData = new UnitInfoData("INFO_UNIT_LISTENER");
        infoData.setTitle(this.getTitle("INFO_UNIT_LISTENER"));
        int i = 0;
        while (i < Udb.getUnitListenerSize()) {
            infoData.add((String)Udb.getUnitListener(i));
            ++i;
        }
        this.setUnitInfoData(infoData);
    }

    private void addUnitMethodInformation(UnitBaseImpl unit) {
        UnitInfoData infoData = new UnitInfoData("INFO_METHOD");
        infoData.setTitle(this.getTitle("INFO_METHOD"));
        Class<?> clsUnit = unit.getClass();
        List<String> UnitMethod = this.getMethod(clsUnit);
        for (String strMethod : UnitMethod) {
            int intKakko;
            if (strMethod.indexOf("public") < 0 || strMethod.indexOf("java.lang.Object.") >= 0 || strMethod.indexOf("doAction") >= 0 || strMethod.indexOf("UnitBaseCtrl") >= 0 || strMethod.indexOf("UnitInterfaceListener") >= 0) continue;
            String strSet = strMethod.substring(strMethod.indexOf("public"), strMethod.length());
            int intPiRiod = strSet.lastIndexOf(".", intKakko = strSet.indexOf("("));
            if (intPiRiod > 0) {
                strSet = strSet.substring(intPiRiod, strSet.length());
            }
            strSet = strSet.replaceAll("java.lang.", "");
            String method = String.valueOf(this.strTreePath) + strSet + ";";
            infoData.add(method);
        }
        this.setUnitInfoData(infoData);
    }

    public void addChildUnitInformation(UnitBaseImpl unit) {
        JpDetailBean jdb;
        if (!(unit instanceof ProxyUnit)) {
            this.remove("CHILD_UNIT");
        }
        if ((jdb = JpDetailBean.getInstance(unit)).size() == 0) {
            return;
        }
        UnitInfoData infoData = new UnitInfoData("CHILD_UNIT");
        infoData.setTitle(this.getTitle("CHILD_UNIT"));
        String childLst = "";
        boolean first = true;
        if (jdb != null) {
            for (String unitName : jdb.getJpUnitNameList()) {
                if (!first) {
                    childLst = String.valueOf(childLst) + ",";
                }
                childLst = String.valueOf(childLst) + unitName;
                first = false;
            }
            infoData.add(childLst);
        }
        this.setUnitInfoData(infoData);
    }

    private List<String> getMethod(Class cls) {
        ArrayList<String> UnitMethod = new ArrayList<String>();
        try {
            Method[] methods = cls.getMethods();
            int i = 0;
            while (i < methods.length) {
                UnitMethod.add(methods[i].toString());
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return UnitMethod;
    }

    public void setUnitInfoData(String strType, String strValue) {
        UnitInfoData info = new UnitInfoData(strType);
        info.add(strValue);
        info.setTitle(this.getTitle(strType));
        this.setUnitInfoData(info);
    }

    public void setUnitInfoData(UnitInfoData info) {
        this.hashInfoData.put(info.getInfoType(), info);
    }

    public UnitInfoData getUnitInfoData(String dataset) {
        return this.hashInfoData.get(dataset);
    }

    public void remove(String dataset) {
        this.hashInfoData.remove(dataset);
    }

    public int size() {
        return this.hashInfoData.size();
    }

    public LinkedList<UnitInfoData> getInfoData() {
        LinkedList<UnitInfoData> ret = new LinkedList<UnitInfoData>();
        HashMap tmpHashInfoData = (HashMap)this.hashInfoData.clone();
        String[] stringArray = this.defalu_keys;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String key = stringArray[n];
            if (this.hashInfoData.get(key) != null) {
                ret.add(this.hashInfoData.get(key));
            }
            tmpHashInfoData.remove(key);
            ++n;
        }
        if (tmpHashInfoData.size() > 0) {
            Set set = tmpHashInfoData.keySet();
            for (String strobject : set) {
                ret.add((UnitInfoData)tmpHashInfoData.get(strobject));
            }
        }
        return ret;
    }
}

