/*
 * Decompiled with CFR 0.152.
 */
package jp.common.navigate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jp.common.JpDetailBean;
import jp.common.LogPrint;
import jp.common.UnitBaseImpl;
import jp.common.UnitDetailBean;
import jp.common.UnitLogBase;
import jp.common.jplink.jplink;
import jp.common.navigate.InfomationPanel;
import jp.common.navigate.JarFilter;
import jp.common.navigate.dlgAccess;
import jp.common.navigate.dlgChildFolderUnit;
import jp.common.navigate.dlgChildUnit;
import jp.common.navigate.dlgJavaScriptUnit;
import jp.common.navigate.dlgLinkCommond;
import jp.common.navigate.dlgLinkOpen;
import jp.common.navigate.dlgLinkRemove;
import jp.common.navigate.dlgPulgin;
import jp.common.navigate.logData;

public class NaviGateDefaultPanel
extends JPanel
implements UnitBaseImpl,
ActionListener,
DropTargetListener,
UnitLogBase {
    private boolean blnBoot = false;
    private JTextField txtJpScript;
    private JButton btnPrint;
    private JTextPane txtLogPrintArea;
    private JCheckBoxMenuItem chkAnonymous = null;
    private boolean blnNgLog = false;
    private JMenuItem close;
    private JMenuItem version;
    private JMenuItem SystemClose;
    private JCheckBoxMenuItem CheckDebug = null;
    private JCheckBoxMenuItem CheckInfo = null;
    private JCheckBoxMenuItem CheckError = null;
    private JCheckBoxMenuItem CheckFatal = null;
    private JCheckBoxMenuItem CheckWarn = null;
    JMenu mnuLog = null;
    ButtonGroup mnuLogGroup = new ButtonGroup();
    InfomationPanel pnlInfomation;
    boolean isLogPrintValid = false;
    LinkedList<logData> lstLogData = new LinkedList();

    public NaviGateDefaultPanel() {
        UnitDetailBean myUdb = JpDetailBean.getUnitDetail(this);
        myUdb.setString("UnitName", "\u306a\u3073Gate\u6a19\u6e96\u30b3\u30f3\u30bd\u30fc\u30eb");
        this.setString("version", "0.0.6");
        this.setString("creator", "\u5e7b\u6708\u8f1d\u591c");
        this.setString("since", "2008.9.27");
        myUdb.addUnitListener("DEFAULT_LOGGER");
        myUdb.addUnitListener("LOGGER_UNIT_LIST");
    }

    public void doAction() {
        if (this.blnBoot) {
            return;
        }
        this.setLayout(new BorderLayout());
        JPanel pnlNorth = new JPanel();
        pnlNorth.setLayout(new BorderLayout());
        JMenuBar menuBerMain = this.getMenu();
        pnlNorth.add("North", menuBerMain);
        this.add("North", pnlNorth);
        this.pnlInfomation = new InfomationPanel();
        this.txtLogPrintArea = new JTextPane();
        new DropTarget(this.txtLogPrintArea, this);
        JScrollPane scrollPane = new JScrollPane(this.txtLogPrintArea);
        JSplitPane split = new JSplitPane(1, this.pnlInfomation, scrollPane);
        split.setDividerLocation(200);
        split.setOneTouchExpandable(true);
        this.add("Center", split);
        JPanel pnlSouth = new JPanel();
        pnlSouth.setLayout(new BorderLayout());
        this.txtJpScript = new JTextField();
        this.txtJpScript.addActionListener(this);
        new DropTarget(this.txtJpScript, this);
        JLabel lblJpScript = new JLabel("JpScript:");
        pnlSouth.add("West", lblJpScript);
        pnlSouth.add("Center", this.txtJpScript);
        this.btnPrint = new JButton("\u5b9f\u884c");
        this.btnPrint.addActionListener(this);
        pnlSouth.add("East", this.btnPrint);
        this.add("South", pnlSouth);
        new DropTarget(this, this);
        this.blnBoot = true;
        this.blnNgLog = true;
    }

    public JMenuBar getMenu() {
        JMenuBar menuBerMain = new JMenuBar();
        JMenu mnuSomething = new JMenu("\u5168\u822c");
        this.CheckDebug = new JCheckBoxMenuItem("Debug\u3092\u30ed\u30b0\u51fa\u529b\u3059\u308b");
        this.CheckDebug.setState(false);
        mnuSomething.add(this.CheckDebug);
        this.CheckInfo = new JCheckBoxMenuItem("Info\u3092\u30ed\u30b0\u51fa\u529b\u3059\u308b");
        this.CheckInfo.setState(true);
        mnuSomething.add(this.CheckInfo);
        this.CheckWarn = new JCheckBoxMenuItem("Warn\u3092\u30ed\u30b0\u51fa\u529b\u3059\u308b");
        this.CheckWarn.setState(true);
        mnuSomething.add(this.CheckWarn);
        this.CheckError = new JCheckBoxMenuItem("Error\u3092\u30ed\u30b0\u51fa\u529b\u3059\u308b");
        this.CheckError.setState(true);
        mnuSomething.add(this.CheckError);
        this.CheckFatal = new JCheckBoxMenuItem("Fatal\u3092\u30ed\u30b0\u51fa\u529b\u3059\u308b");
        this.CheckFatal.setState(true);
        mnuSomething.add(this.CheckFatal);
        mnuSomething.addSeparator();
        this.version = new JMenuItem("\u30f4\u30a1\u30fc\u30b8\u30e7\u30f3");
        this.version.setActionCommand("jp.common.viewVersion('jp.common.navigate');");
        this.version.addActionListener(this);
        mnuSomething.add(this.version);
        mnuSomething.addSeparator();
        this.close = new JMenuItem("\u7d42\u4e86");
        this.close.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.close.setActionCommand("jp.common.navigate.close();");
        this.close.addActionListener(this);
        mnuSomething.add(this.close);
        mnuSomething.addSeparator();
        JMenu mnuSystem = new JMenu("JpSystem");
        this.SystemClose = new JMenuItem("\u5f37\u5236\u7d42\u4e86(\u5c01\u6bba\u5b9f\u884c)");
        this.SystemClose.setActionCommand("jp.common.forceout();");
        this.SystemClose.addActionListener(this);
        mnuSystem.add(this.SystemClose);
        mnuSomething.add(mnuSystem);
        menuBerMain.add(mnuSomething);
        JMenu mnuCommand = new JMenu("\u30b3\u30de\u30f3\u30c9");
        mnuCommand.add(this.createJMenuItem("Jar\u306eUnit\u3092\u53d6\u308a\u8fbc\u3080", KeyStroke.getKeyStroke(70, 8), "jarLoad"));
        mnuCommand.add(this.createJMenuItem("\u30d5\u30a9\u30eb\u30c0\u5185\u306eUnit\u3092\u30bb\u30c3\u30c8\u3067\u8aad\u307f\u8fbc\u3080", KeyStroke.getKeyStroke(70, 9), "folderRead"));
        mnuCommand.addSeparator();
        mnuCommand.add(this.createJMenuItem("Jar\u3067\u914d\u5e03\u3055\u308c\u305fUnit\u3092\u4e0b\u5c64\u306b\u53d6\u308a\u8fbc\u3080", KeyStroke.getKeyStroke(85, 8), "childRead"));
        mnuCommand.add(this.createJMenuItem("\u30d5\u30a9\u30eb\u30c0\u5185\u90e8\u306e\u3059\u3079\u3066\u306eUnit\u3092\u4e0b\u5c64\u306b\u53d6\u308a\u8fbc\u3080", KeyStroke.getKeyStroke(85, 9), "childFolder"));
        mnuCommand.addSeparator();
        mnuCommand.add(this.createJMenuItem("JavaScriptUnit\u306e\u8aad\u8fbc", KeyStroke.getKeyStroke(74, 8), "viewJsuDialog"));
        mnuCommand.addSeparator();
        mnuCommand.add(this.createJMenuItem("JpLink\u306e\u4f5c\u6210", KeyStroke.getKeyStroke(79, 8), "linkOpen"));
        mnuCommand.add(this.createJMenuItem("Link\u5148\u3078\u30b3\u30de\u30f3\u30c9\u9001\u4ed8", KeyStroke.getKeyStroke(67, 8), "linkCommand"));
        mnuCommand.add(this.createJMenuItem("JpLink\u306e\u958b\u653e", KeyStroke.getKeyStroke(82, 8), "linkRemove"));
        mnuCommand.addSeparator();
        mnuCommand.add(this.createJMenuItem("JpLink\u306e\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u8a2d\u5b9a", KeyStroke.getKeyStroke(83, 8), "linkSetting"));
        this.chkAnonymous = new JCheckBoxMenuItem("JpLink\u306eAnonymous\u3067\u306e\u63a5\u7d9a\u3092\u6709\u52b9\u306b\u3059\u308b\u3002");
        this.chkAnonymous.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.chkAnonymous.addActionListener(this);
        this.chkAnonymous.setSelected(jplink.getAnonymous());
        mnuCommand.add(this.chkAnonymous);
        menuBerMain.add(mnuCommand);
        if (this.mnuLog == null) {
            this.mnuLog = new JMenu("\u30ed\u30b0\u51fa\u529b\u5148");
        }
        if (this.mnuLogGroup == null) {
            this.mnuLogGroup = new ButtonGroup();
        }
        menuBerMain.add(this.mnuLog);
        return menuBerMain;
    }

    protected String getJpPath() {
        UnitDetailBean myUdb = JpDetailBean.getUnitDetail(this);
        String strMyJpPath = myUdb.getString("MyJpPath");
        String jppath = "jp." + strMyJpPath;
        return jppath;
    }

    protected String getSuperUnit() {
        UnitDetailBean myUdb = JpDetailBean.getUnitDetail(this);
        String ParentJpPath = myUdb.getString("ParentJpPath");
        String superunit = "jp." + ParentJpPath;
        return superunit;
    }

    private String getMyJpCommand(String method) {
        String jpCommand = String.valueOf(this.getJpPath()) + "." + method + "();";
        return jpCommand;
    }

    public void actionPerformed(ActionEvent evt) {
        String jpCommand = evt.getActionCommand();
        if (jpCommand != null && jpCommand.indexOf("jp.") == 0) {
            JpDetailBean.JpCommandRunning(jpCommand);
            return;
        }
        if (evt.getSource() instanceof JRadioButtonMenuItem) {
            String strLogSelect = evt.getActionCommand();
            String strCommand = "jp.common.logprint.setDefaultLogger('" + strLogSelect + "');";
            JpDetailBean.JpCommandRunning(strCommand);
        } else if (this.btnPrint == evt.getSource() || this.txtJpScript == evt.getSource()) {
            String jpWord = this.txtJpScript.getText();
            if (jpWord.indexOf("@") == 0) {
                jpWord = jpWord.substring(1, jpWord.length());
                jpWord = "jp.common.navigate.checkJpPath(" + jpWord.replaceAll(";", "") + ");";
                LogPrint.setLogPrint("UnitData:" + jpWord, "I");
                JpDetailBean.JpCommandRunning(jpWord);
            } else {
                LogPrint.setLogPrint("JpScriptExec:" + jpWord, "I");
                JpDetailBean.JpCommandRunning(jpWord);
            }
        } else if (this.chkAnonymous == evt.getSource()) {
            JpDetailBean.JpCommandRunning("jp.common.jplink.setAnonymous(" + this.getAnonymousState() + ");");
        }
    }

    private JMenuItem createJMenuItem(String menutitie, KeyStroke ks, String ac) {
        JMenuItem item = new JMenuItem(menutitie);
        item.addActionListener(this);
        item.setAccelerator(ks);
        item.setActionCommand(this.getMyJpCommand(ac));
        return item;
    }

    public void linkCommand() {
        Vector<String> vecLink = new Vector<String>();
        int i = 0;
        while (i < jplink.size()) {
            vecLink.add(jplink.get(i));
            ++i;
        }
        dlgLinkCommond dialog = new dlgLinkCommond(null, vecLink);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void linkRemove() {
        Vector<String> vecLink = new Vector<String>();
        int i = 0;
        while (i < jplink.size()) {
            vecLink.add(jplink.get(i));
            ++i;
        }
        dlgLinkRemove dialog = new dlgLinkRemove(null, vecLink);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void linkSetting() {
        dlgAccess dialog = new dlgAccess(null);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void linkOpen() {
        dlgLinkOpen dialog = new dlgLinkOpen(null);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void childFolder() {
        JpDetailBean JpUnit = JpDetailBean.getInstance();
        List<String> listJpUnitName = JpUnit.getJpUnitNameList();
        dlgChildFolderUnit dialog = new dlgChildFolderUnit(null, listJpUnitName);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void childRead() {
        JpDetailBean JpUnit = JpDetailBean.getInstance();
        List<String> listJpUnitName = JpUnit.getJpUnitNameList();
        dlgChildUnit dialog = new dlgChildUnit(null, listJpUnitName);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void jarLoad() {
        try {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.setDialogTitle("JAR\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc");
            chooser.addChoosableFileFilter(new JarFilter());
            int loadACcept = chooser.showOpenDialog(this);
            if (loadACcept != 0) {
                if (loadACcept == 1) {
                    LogPrint.setLogPrint("\u30d5\u30a1\u30a4\u30eb\u5c55\u958b\u53d6\u6d88\u627f\u8afe", "I");
                    return;
                }
                if (loadACcept == -1) {
                    LogPrint.setLogPrint("\u30d5\u30a1\u30a4\u30eb\u5c55\u958b\u62d2\u5426\u627f\u8afe", "I");
                    return;
                }
                LogPrint.setLogPrint("\u60f3\u5b9a\u5916\u306e\u8fd4\u7b54\u304c\u5e30\u3063\u3066\u304d\u307e\u3057\u305f:loadACcept = [" + loadACcept + "]", "E");
                return;
            }
            String strJpCommand = "jp.common.setJarFile('" + chooser.getSelectedFile() + "');";
            JpDetailBean.JpCommandRunning(strJpCommand);
            JpDetailBean.JpCommandRunning("jp.common.navigate.setTreeRepaint();");
        }
        catch (Exception e) {
            LogPrint.setLogPrint("Unit\u5c55\u958b\u6642\u306b\u81f4\u547d\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u51e6\u7406\u306f\u4e2d\u65ad\u3057\u307e\u305b\u3093\u304c\u3001\u4ed6\u306e\u30c6\u30ad\u30b9\u30c8\u30c4\u30fc\u30eb\u7b49\u3067\u901f\u3084\u304b\u306b\u30c7\u30fc\u30bf\u3092\u4fdd\u5b58\u306a\u3055\u308c\u308b\u3053\u3068\u3092\u52e7\u544a\u3057\u307e\u3059", "E");
        }
    }

    public void folderRead() {
        dlgPulgin dialog = new dlgPulgin(null);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void viewJsuDialog() {
        JpDetailBean JpUnit = JpDetailBean.getInstance();
        List<String> listJpUnitName = JpUnit.getJpUnitNameList();
        dlgJavaScriptUnit dialog = new dlgJavaScriptUnit(null, listJpUnitName);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void UnitInterfaceListener(String strKeyWord) {
        UnitDetailBean myUdb = JpDetailBean.getUnitDetail(this);
        if ("DEFAULT_LOGGER".equals(strKeyWord)) {
            String strDefalutLog = myUdb.getString("DEFAULT_LOGGER");
            this.setLogger(strDefalutLog);
        } else if ("LOGGER_UNIT_LIST".equals(strKeyWord)) {
            String strLoggerList = myUdb.getString("LOGGER_UNIT_LIST");
            this.clearLogger();
            this.setLoggerList(strLoggerList);
        }
    }

    public void setString(String strKey, String strValue) {
        try {
            UnitDetailBean myUdb = JpDetailBean.getUnitDetail(this);
            myUdb.setString(strKey, strValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List myList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (myList.size() == 1) {
                    File myFile = (File)myList.get(0);
                    JpDetailBean.JpCommandRunning("jp.common.setJarFile('" + myFile.getPath() + "');");
                    JpDetailBean.JpCommandRunning("jp.common.navigate.setTreeRepaint();");
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (IOException ioe) {
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            dtde.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void setLogger(String strLogger) {
        Component[] mesLogger = this.mnuLog.getMenuComponents();
        int iCount = 0;
        while (iCount < mesLogger.length) {
            JRadioButtonMenuItem radioNow;
            Component meNow = mesLogger[iCount];
            if (meNow instanceof JRadioButtonMenuItem && strLogger.equals((radioNow = (JRadioButtonMenuItem)meNow).getActionCommand())) {
                radioNow.setSelected(true);
            }
            ++iCount;
        }
    }

    public void clearLogger() {
        Component[] mesLogger = this.mnuLog.getMenuComponents();
        int iCount = 0;
        while (iCount < mesLogger.length) {
            Component meNow = mesLogger[iCount];
            if (meNow instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem radioNow = (JRadioButtonMenuItem)meNow;
                this.mnuLogGroup.remove(radioNow);
                this.mnuLog.remove(radioNow);
            }
            ++iCount;
        }
    }

    public void setLoggerList(String strLoggerList) {
        String[] Loggers;
        String[] stringArray = Loggers = strLoggerList.split(",");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String Logger2 = stringArray[n];
            String[] LogUnitData = Logger2.split(":");
            if (LogUnitData.length > 1) {
                this.addLogger(LogUnitData[0], LogUnitData[1]);
            }
            ++n;
        }
    }

    public void addLogger(String strLoggerName, String strLogger) {
        JRadioButtonMenuItem radioNabiGate = new JRadioButtonMenuItem(strLoggerName, true);
        radioNabiGate.addActionListener(this);
        radioNabiGate.setActionCommand(strLogger);
        this.mnuLogGroup.add(radioNabiGate);
        this.mnuLog.add(radioNabiGate);
    }

    public boolean isUse() {
        return this.getNgLog();
    }

    protected boolean getNgLog() {
        return this.blnNgLog;
    }

    public void info(String objTarget, Object strOut) {
        this.setLogPrint(objTarget, strOut, "I");
    }

    public void info(String objTarget, String strOut) {
        this.setLogPrint(objTarget, strOut, "I");
    }

    public void debug(String objTarget, Object strOut) {
        this.setLogPrint(objTarget, strOut, "D");
    }

    public void debug(String objTarget, String strOut) {
        this.setLogPrint(objTarget, strOut, "D");
    }

    public void error(String objTarget, Object strOut) {
        this.setLogPrint(objTarget, strOut, "E");
    }

    public void error(String objTarget, String strOut) {
        this.setLogPrint(objTarget, strOut, "E");
    }

    public void fatal(String objTarget, Object strOut) {
        this.setLogPrint(objTarget, strOut, "F");
    }

    public void fatal(String objTarget, String strOut) {
        this.setLogPrint(objTarget, strOut, "F");
    }

    public void warn(String objTarget, Object strOut) {
        this.setLogPrint(objTarget, strOut, "W");
    }

    public void warn(String objTarget, String strOut) {
        this.setLogPrint(objTarget, strOut, "W");
    }

    public void trace(String objTarget, Object strOut) {
        this.setLogPrint(objTarget, strOut, "T");
    }

    public void trace(String objTarget, String strOut) {
        this.setLogPrint(objTarget, strOut, "T");
    }

    public void setLogPrint(Object objTarget, Object strOut, String strType) {
        this.setTxtArea("[" + objTarget + "] " + strOut, strType);
    }

    protected void doOutLstLogData() {
        if (!this.isLogPrintValid) {
            for (logData data : this.lstLogData) {
                this.insertString(data.getAppend(), data.getType());
            }
            this.lstLogData.clear();
        }
    }

    public void setTxtArea(String strAppend, String strType) {
        if (this.txtLogPrintArea != null && ("D".equals(strType) && this.getCheckDebugState() || "I".equals(strType) && this.getCheckInfoState() || "E".equals(strType) && this.getCheckErrorState() || "F".equals(strType) && this.getCheckFatalState() || "W".equals(strType) && this.getCheckWarnState())) {
            if (this.txtLogPrintArea.isValid()) {
                this.doOutLstLogData();
                this.insertString(strAppend, strType);
                this.isLogPrintValid = true;
            }
            if (!this.isLogPrintValid) {
                logData data = new logData();
                data.setAppend(strAppend);
                data.setType(strType);
                if (this.lstLogData.size() < 255) {
                    this.lstLogData.add(data);
                }
            }
        }
    }

    private void insertString(final String strAppend, final String strType) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleAttributeSet sas = new SimpleAttributeSet();
                SimpleAttributeSet sas2 = new SimpleAttributeSet();
                StyleConstants.setBold(sas, true);
                StyleConstants.setFontFamily(sas, "Monospaced");
                if ("D".equals(strType) && NaviGateDefaultPanel.this.getCheckDebugState()) {
                    StyleConstants.setForeground(sas, Color.GRAY);
                    StyleConstants.setForeground(sas2, Color.GRAY);
                } else if ("I".equals(strType) && NaviGateDefaultPanel.this.getCheckInfoState()) {
                    StyleConstants.setForeground(sas, Color.BLUE);
                } else if ("E".equals(strType) && NaviGateDefaultPanel.this.getCheckErrorState()) {
                    StyleConstants.setForeground(sas, Color.RED);
                    StyleConstants.setBold(sas2, true);
                } else if ("F".equals(strType) && NaviGateDefaultPanel.this.getCheckFatalState()) {
                    StyleConstants.setForeground(sas, Color.RED);
                    StyleConstants.setForeground(sas2, Color.RED);
                    StyleConstants.setBold(sas2, true);
                } else if ("W".equals(strType) && NaviGateDefaultPanel.this.getCheckWarnState()) {
                    StyleConstants.setForeground(sas, Color.MAGENTA);
                }
                try {
                    Document doc = NaviGateDefaultPanel.this.txtLogPrintArea.getDocument();
                    doc.insertString(doc.getLength(), "[" + strType + "]", sas);
                    doc.insertString(doc.getLength(), String.valueOf(strAppend) + "\n", sas2);
                    NaviGateDefaultPanel.this.txtLogPrintArea.setCaretPosition(doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean getCheckDebugState() {
        return this.CheckDebug.getState();
    }

    public boolean getCheckInfoState() {
        return this.CheckInfo.getState();
    }

    public boolean getCheckErrorState() {
        return this.CheckError.getState();
    }

    public boolean getCheckFatalState() {
        return this.CheckFatal.getState();
    }

    public boolean getCheckWarnState() {
        return this.CheckWarn.getState();
    }

    public void setRootNode() {
        if (this.pnlInfomation == null) {
            return;
        }
        this.pnlInfomation.setRootRepaint();
    }

    public void setNodeRepaint(String path) {
        if (this.pnlInfomation == null) {
            return;
        }
        this.pnlInfomation.setRepaint(path);
    }

    public void setUnitViewUpdate() {
        if (this.pnlInfomation == null) {
            return;
        }
        this.pnlInfomation.setUnitViewUpdate();
    }

    public void setInfomation(String jpPath) {
        if (this.pnlInfomation == null) {
            return;
        }
        this.pnlInfomation.setInfomation(jpPath);
    }

    public boolean getAnonymousState() {
        return this.chkAnonymous.getState();
    }

    public void setAnonymousState(boolean blnAnonymous) {
        this.chkAnonymous.setState(blnAnonymous);
    }
}

