/*
 * Decompiled with CFR 0.152.
 */
package jp.common.sandbox;

import java.lang.reflect.ReflectPermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.common.LogPrint;
import jp.common.sandbox.ReceiverPermission;
import jp.common.sandbox.Terminator;

public class SandBox
extends SecurityManager {
    public static final SocketPermission SOCKET_PARMISSION = new SocketPermission("*", "accept,connect,listen");
    public static final ReceiverPermission RECEIVER_PARMISSION = new ReceiverPermission();
    private static Map classMap;
    private static SandBox instance;

    private SandBox() {
        SandBox.addPrivilege("java.net.InetAddress", SOCKET_PARMISSION);
        SandBox.addPrivilege("jp.common.socket.MonitoringInputStream", RECEIVER_PARMISSION);
        SandBox.addPrivilege("java.net.URL", SOCKET_PARMISSION);
        SandBox.addPrivilege("java.net.URLConnection", SOCKET_PARMISSION);
        SandBox.addPrivilege("java.net.HttpURLConnection", SOCKET_PARMISSION);
        SandBox.addPrivilege("java.net.JarURLConnection", SOCKET_PARMISSION);
        SandBox.addPrivilege("sun.net.www.http.HttpClient", SOCKET_PARMISSION);
        SandBox.addPrivilege("SUN", SOCKET_PARMISSION);
    }

    public static SandBox getInstance() {
        if (instance == null) {
            instance = new SandBox();
        }
        return instance;
    }

    private static Map getMap() {
        if (classMap == null) {
            classMap = Collections.synchronizedMap(new HashMap());
        }
        return classMap;
    }

    private static PermissionCollection getPermissions(String className) {
        if (SandBox.getMap().get(className) == null) {
            Permissions pc = new Permissions();
            SandBox.getMap().put(className, pc);
            return pc;
        }
        return (PermissionCollection)SandBox.getMap().get(className);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkPermission(Permission p) throws SecurityException {
        if (p instanceof SocketPermission) {
            if (p.getName().equals("") || p.getName().equals("localhost")) {
                LogPrint.setLogPrint("\u30ed\u30fc\u30ab\u30eb\u63a5\u7d9a\u306a\u306e\u3067\u63a5\u7d9a\u3092\u8a31\u53ef\u3055\u308c\u307e\u3059\u3002", "D");
                return;
            }
            if (SandBox.isJpSocket()) {
                LogPrint.setLogPrint("JpSocket\u306f\u4f8b\u5916\u7684\u306b\u63a5\u7d9a\u3092\u8a31\u53ef\u3055\u308c\u307e\u3059\u3002", "D");
                return;
            }
            if (SandBox.isPrivilegedSocket()) {
                LogPrint.setLogPrint("\u7279\u6a29\u3092\u4e0e\u3048\u3089\u308c\u305f\u30af\u30e9\u30b9\u306a\u306e\u3067\u63a5\u7d9a\u3092\u8a31\u53ef\u3055\u308c\u307e\u3059\u3002", "D");
                return;
            }
            LogPrint.setLogPrint("\u901a\u5e38\u306e\u30bd\u30b1\u30c3\u30c8\u3092\u5229\u7528\u3057\u305f\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u63a5\u7d9a\u306f\u8a31\u53ef\u3055\u308c\u307e\u305b\u3093\u3002", "E");
            LogPrint.setLogPrint("jp.common.socket\u30d1\u30c3\u30b1\u30fc\u30b8\u5185\u306e\u5404\u7a2eSocket\u30af\u30e9\u30b9\u3092\u5229\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "E");
            throw new SecurityException();
        }
        if (p instanceof SecurityPermission) {
            return;
        }
        if (p instanceof RuntimePermission) {
            if (!"exitVM".equals(p.getName())) return;
            Terminator.getInstance().terminate();
            return;
        }
        boolean cfr_ignored_0 = p instanceof ReflectPermission;
    }

    private static void addPrivilege(String className, Permission permission) {
        PermissionCollection pc = SandBox.getPermissions(className);
        if (!pc.implies(permission)) {
            pc.add(permission);
        }
    }

    private static boolean isPrivileged(String className, Permission permission) {
        Map map = SandBox.getMap();
        if (map.get(className) == null) {
            return false;
        }
        PermissionCollection pc = (PermissionCollection)map.get(className);
        return pc.implies(permission);
    }

    public static boolean isNetworkedProcess() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int i = 2;
        while (i < stackTrace.length) {
            if (SandBox.isPrivileged(stackTrace[i].getClassName(), SOCKET_PARMISSION)) {
                return true;
            }
            if (SandBox.isPrivileged(stackTrace[i].getClassName(), RECEIVER_PARMISSION)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrivilegedSocket() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int i = 2;
        while (i < stackTrace.length) {
            if (SandBox.isPrivileged(stackTrace[i].getClassName(), SOCKET_PARMISSION)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isJpSocket() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int i = 2;
        while (i < stackTrace.length) {
            if (stackTrace[i].getClassName().equals("jp.common.socket.JpSocket")) {
                return true;
            }
            if (stackTrace[i].getClassName().equals("jp.common.socket.JpSSLSocket")) {
                return true;
            }
            if (stackTrace[i].getClassName().equals("jp.common.socket.JpServerSocket")) {
                return true;
            }
            if (stackTrace[i].getClassName().equals("jp.common.socket.JpDatagramSocket")) {
                return true;
            }
            if (stackTrace[i].getClassName().equals("jp.common.socket.JpMulticastSocket")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addReceiver(String className) {
        PermissionCollection pc = SandBox.getPermissions(className);
        if (!pc.implies(RECEIVER_PARMISSION)) {
            pc.add(RECEIVER_PARMISSION);
        }
    }
}

