/*
 * Decompiled with CFR 0.152.
 */
package jp.geoark.sstp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jp.common.socket.JpSocket;
import jp.geoark.sstp.GhostScript;
import jp.geoark.sstp.SstpException;

public class SstpConnection {
    private InetAddress addr;
    private int port;
    String sender = null;
    String encoding = null;
    String encodingSstp = null;

    public SstpConnection() throws UnknownHostException {
        this("127.0.0.1", 9801);
    }

    public SstpConnection(InetAddress addrSrc, int portSrc) {
        this.addr = addrSrc;
        this.port = portSrc;
        this.encodingSstp = this.encoding = "SJIS";
        this.setSender("SSTP WRAPPER");
    }

    public SstpConnection(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    public SstpConnection(InetAddress addr) {
        this(addr, 9801);
    }

    public SstpConnection(String host) throws UnknownHostException {
        this(host, 9801);
    }

    public void setSender(String name) {
        this.sender = name;
    }

    public String getSender() {
        return this.sender;
    }

    public void setEncode(String encode) throws UnsupportedEncodingException {
        if ("SJIS".equals(encode)) {
            this.encoding = "SJIS";
        } else if ("JIS".equals(encode)) {
            this.encoding = "JIS0208";
        } else if ("EUC".equals(encode)) {
            this.encoding = "EUC_JP";
        } else if ("UTF-8".equals(encode)) {
            this.encoding = "UTF-8";
        } else {
            throw new UnsupportedEncodingException("unsupported by sstp");
        }
        this.encodingSstp = encode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String request(String request, String msg) throws IOException {
        String result;
        InputStreamReader isr;
        OutputStreamWriter osw;
        JpSocket sock;
        block14: {
            sock = null;
            osw = null;
            isr = null;
            PrintWriter pw = null;
            BufferedReader br = null;
            result = null;
            try {
                try {
                    sock = new JpSocket(this.addr, this.port);
                    osw = new OutputStreamWriter(sock.getOutputStream(), this.encoding);
                    isr = new InputStreamReader(sock.getInputStream(), this.encoding);
                    pw = new PrintWriter(osw);
                    br = new BufferedReader(isr);
                    result = this.requestMain(request, msg, pw, br);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IOException("can't use " + this.encoding + " encoding....");
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (pw != null) {
                    pw.close();
                }
                if (br != null) {
                    br.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (sock == null) throw throwable;
                sock.close();
                throw throwable;
            }
            {
                Object var10_14 = null;
                if (pw != null) {
                    pw.close();
                }
                if (br == null) break block14;
            }
            br.close();
        }
        if (osw != null) {
            osw.close();
        }
        if (isr != null) {
            isr.close();
        }
        if (sock == null) return result;
        sock.close();
        return result;
    }

    private synchronized String requestMain(String request, String msg, PrintWriter pw, BufferedReader br) throws IOException {
        StringBuffer send = new StringBuffer(request);
        send.append("\r\n");
        send.append("Sender: ");
        send.append(this.sender);
        send.append("\r\n");
        send.append(msg);
        int len = msg.length();
        if (len < 2) {
            send.append("\r\n");
        } else if (!msg.substring(len - 2, len).equals("\r\n")) {
            send.append("\r\n");
        }
        send.append("Charset: ");
        send.append(this.encodingSstp);
        send.append("\r\n");
        send.append("\r\n");
        String strSendWord = send.toString();
        String strOs = System.getProperty("os.name");
        if (strOs.indexOf("Windows") != -1) {
            strSendWord = strSendWord.replaceAll("\uff5e", "\u301c");
            strSendWord = strSendWord.replaceAll("\uff0d", "\u2212");
            strSendWord = strSendWord.replaceAll("\u2225", "\u2016");
            strSendWord = strSendWord.replaceAll("\uffe0", "\u00a2");
            strSendWord = strSendWord.replaceAll("\uffe1", "\u00a3");
            strSendWord = strSendWord.replaceAll("\uffe2", "\u00ac");
        }
        pw.print(strSendWord);
        pw.flush();
        String status = br.readLine();
        int code = 0;
        if (status != null) {
            StringTokenizer token = new StringTokenizer(status);
            try {
                token.nextToken();
                code = Integer.parseInt(token.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (status == null || code == 0) {
            throw new SstpException(0, "\u30b9\u30c6\u30fc\u30bf\u30b9\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        if (code != 200) {
            throw new SstpException(code, status);
        }
        StringBuffer result = new StringBuffer();
        String temp = null;
        while ((temp = br.readLine()) != null) {
            if (result.length() > 0) {
                result.append(System.getProperty("line.separator"));
            }
            result.append(temp);
        }
        len = result.length();
        if (len >= 2 && result.substring(len - 2, len).equals("\r\n")) {
            result.delete(len - 2, len);
        }
        return result.toString();
    }

    public void send(String sakuraScript, boolean optionNodescript, boolean optionNotranslate) throws IOException {
        StringBuffer msg = new StringBuffer();
        msg.append("Script: ");
        msg.append(sakuraScript);
        if (optionNodescript && optionNotranslate) {
            msg.append("\r\nOption: nodescript,notranslate");
        } else if (optionNodescript) {
            msg.append("\r\nOption: nodescript");
        } else if (optionNotranslate) {
            msg.append("\r\nOption: notranslate");
        }
        this.request("SEND SSTP/1.1", msg.toString());
    }

    public void send(String script) throws IOException {
        this.send(script, false, false);
    }

    public String sendEntry(String script, String[] entry) throws IOException {
        StringBuffer msg = new StringBuffer();
        msg.append("Script: ");
        msg.append(script);
        if (entry != null) {
            int i = 0;
            while (i < entry.length) {
                msg.append("\r\nEntry: ");
                msg.append(entry[i]);
                ++i;
            }
        }
        return this.request("SEND SSTP/1.2", msg.toString());
    }

    public String send(GhostScript[] gscript) throws IOException {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < gscript.length) {
            if (i > 0) {
                msg.append("\r\n");
            }
            msg.append("IfGhost: ");
            msg.append(gscript[i].ghostNameMainBody);
            msg.append(",");
            msg.append(gscript[i].ghostNameUnyu);
            msg.append("\r\nScript: ");
            msg.append(gscript[i].sakuraScript);
            if (gscript[i].entry != null) {
                int n = 0;
                while (n < gscript[i].entry.length) {
                    msg.append("\r\nEntry: ");
                    msg.append(gscript[i].entry[n]);
                    ++n;
                }
            }
            ++i;
        }
        return this.request("SEND SSTP/1.4", msg.toString());
    }

    public String execute(String command) throws IOException {
        return this.request("EXECUTE SSTP/1.0", "Command: " + command);
    }

    public void setCookie(String entry, String value) throws IOException {
        StringBuffer msg = new StringBuffer();
        msg.append("Command: SetCookie[");
        msg.append(entry);
        msg.append(",");
        msg.append(value);
        msg.append("]");
        this.request("EXECUTE SSTP/1.1", msg.toString());
    }

    public String getCookie(String entry) throws IOException {
        StringBuffer msg = new StringBuffer();
        msg.append("Command: GetCookie[");
        msg.append(entry);
        msg.append("]");
        return this.request("EXECUTE SSTP/1.1", msg.toString());
    }

    public String getVersion() throws IOException {
        return this.request("EXECUTE SSTP/1.2", "Command: GetVersion");
    }

    public String communicate(String sentence) throws IOException {
        String result = this.request("COMMUNICATE SSTP/1.1", "Sentence: " + sentence);
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    public String communicate(String sentence, int port) throws IOException {
        StringBuffer msg = new StringBuffer();
        msg.append("Port: ");
        msg.append(Integer.toString(port));
        msg.append("\r\n");
        msg.append("Sentence: ");
        msg.append(sentence);
        msg.append("\r\n");
        String result = this.request("COMMUNICATE SSTP/1.2", msg.toString());
        if (result.length() > 0) {
            return result;
        }
        return null;
    }
}

