/*
 * Decompiled with CFR 0.152.
 */
package jp.geoark.sstp;

import jp.common.JpDetailBean;
import jp.common.UnitBaseCtrl;
import jp.geoark.sstp.SstpConnection;
import jp.geoark.sstp.SstpFrame;

public class SstpWrapper
extends UnitBaseCtrl {
    private static final long serialVersionUID = 6054179439916711795L;
    public static final String LOCAL_PORT = "127.0.0.1";
    public static final int DEFAULT_PORT = 9801;
    public static final String DEFAULT_SENDER = "SSTP WRAPPER";
    public static String MyJpPath = "";
    SstpConnection sstp = null;

    public SstpWrapper() {
        this.setString("UnitName", DEFAULT_SENDER);
        this.setString("version", "0.1.0");
        this.setString("creator", "\u5e7b\u6708\u8f1d\u591c");
        this.setString("since", "2009.01.16");
    }

    public void doAction() {
        String[] args;
        String host = LOCAL_PORT;
        MyJpPath = JpDetailBean.getUnitDetail(this).getString("MyJpPath");
        if (JpDetailBean.getUnitDetail(this).get("boot.args") != null && JpDetailBean.getUnitDetail(this).get("boot.args") instanceof String[] && (args = (String[])JpDetailBean.getUnitDetail(this).get("boot.args")).length > 0) {
            host = args[0];
        }
        try {
            this.sstp = new SstpConnection(host, 9801);
            SstpFrame window = new SstpFrame(this);
            window.setTitle("SSTP WRAPPER(" + host + ")");
            window.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void UnitInterfaceListener(String strCngDataKey) {
    }

    protected String getString(String KeyWord) {
        return JpDetailBean.getUnitDetail(this).getString(KeyWord);
    }

    protected void setString(String KeyWord, String Value) {
        JpDetailBean.getUnitDetail(this).setString(KeyWord, Value);
    }

    protected static String getMyJpPath() {
        return MyJpPath;
    }

    public void version() {
        String strMyJpPath = "jp." + this.getString("MyJpPath");
        JpDetailBean.JpCommandRunning("jp.common.viewVersion('" + strMyJpPath + "');");
    }

    public void setSender(String name) throws Exception {
        this.sstp = this.getSstpConnection();
        if (this.sstp == null) {
            return;
        }
        this.sstp.setSender(name);
    }

    public void send(String sakuraScript, boolean optionNoDescript, boolean optionNoTranslate) throws Exception {
        if (sakuraScript.length() == 0) {
            return;
        }
        this.setString("Exception", "");
        try {
            this.sstp = this.getSstpConnection();
            if (this.sstp == null) {
                return;
            }
            this.sstp.send(sakuraScript, optionNoDescript, optionNoTranslate);
        }
        catch (Exception ex) {
            this.setString("Exception", ex.getMessage());
            throw ex;
        }
    }

    public String execute(String command) throws Exception {
        block3: {
            this.setString("Exception", "");
            try {
                this.sstp = this.getSstpConnection();
                if (this.sstp != null) break block3;
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setString("Exception", ex.getMessage());
                throw ex;
            }
        }
        String retWord = this.sstp.execute(command);
        this.setString(command, retWord);
        return retWord;
    }

    public SstpConnection getSstpConnection() throws Exception {
        if (this.sstp == null) {
            try {
                this.sstp = new SstpConnection(LOCAL_PORT, 9801);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return this.sstp;
    }

    public void close() {
        SstpWrapper.JpCommandRunning("jp.common.setString('SystemExit','SstpWrapper');");
    }
}

