#
# histogram sample
#
package require Img
package require BLT
namespace import blt::*
package require histogram

option add *Font {{lr oSVbN} 10}
wm title . Histogram

option add *graph.red.Color red
option add *graph.green.Color green
option add *graph.blue.Color blue
option add *graph.hue.Color cyan
option add *graph.luminance.Color yellow
option add *graph.saturation.Color magenta
option add *graph.red.Symbol ""
option add *graph.green.Symbol ""
option add *graph.blue.Symbol ""
option add *graph.hue.Symbol ""
option add *graph.luminance.Symbol ""
option add *graph.saturation.Symbol ""
option add *graph.activeLine.Color yellow
option add *graph.activeLine.Symbol circle
option add *graph.Legend.ActiveBackground yellow

proc openimg {} {
	global xdata
	set types {
		{{JPEG Files} {.jpg .jpeg}}
		{{GIF Files} {.gif}}
		{{BMP Files} {.bmp}}
		{{All FIles} *}
	}
	set file [tk_getOpenFile -defaultextension .jpg -filetypes $types -title Open]
	if {$file != ""} {
		catch {image delete img}
		image create photo img -file $file

		histogram::count img

		catch {.graph element delete red green blue hue luminance saturation}
		.graph element create red -xdata $xdata -ydata [histogram::get red]
		.graph element create green -xdata $xdata -ydata [histogram::get green]
		.graph element create blue -xdata $xdata -ydata [histogram::get blue]
		.graph element create hue -xdata $xdata -ydata [histogram::get hue]
		.graph element create luminance -xdata $xdata -ydata [histogram::get luminance]
		.graph element create saturation -xdata $xdata -ydata [histogram::get saturation]
	}
}

set xdata {}
for {set i 0} {$i < 256} {incr i} {
	lappend xdata $i
}

pack [button .b -text Open... -command openimg] -anchor w
pack [graph .graph -width 5i -height 2i] -fill both -expand 1

Blt_ZoomStack .graph
Blt_Crosshairs .graph
Blt_ActiveLegend .graph
Blt_ClosestPoint .graph

.graph element bind all <Enter> {
	%W legend activate [%W element get current]
}

.graph element bind all <Leave> {
	%W legend deactivate [%W element get current]
}
