//
// Copyright (C) 2001 Satoshi Imai
//

#include	"windows.h"
#include	"tclInt.h"
#include	"tkInt.h"

#define PACKAGE		"histogram"		// pbP[W̖
#define VERSION		"1.0"			// pbP[W̔
#define NAMESPACE	"::histogram"		// Namespace

// JE^
int red[256];
int green[256];
int blue[256];
int hue[256];
int luminance[256];
int saturation[256];

//
// RGBl̎擾
//
static int
GetRGB(
	Tk_PhotoImageBlock *b,
	int x,
	int y,
	int *rgb
)
{
	unsigned char *pixelp;

	if(x < 0 || x >= b->width || y < 0 || y >= b->height){
		return 0;
	}
	pixelp = (b->pixelPtr) + y * (b->pitch) + x * (b->pixelSize);
	* (rgb+0) = * (pixelp+(b->offset[0]));
	* (rgb+1) = * (pixelp+(b->offset[1]));
	* (rgb+2) = * (pixelp+(b->offset[2]));
	return 1;
}

//
// RGB/HLS̏Wv
//
static int
CountRGB(
	Tk_PhotoImageBlock *b
)
{
	int rgb[3];
	DWORD hls;
	extern DWORD RGBtoHLS(DWORD lRGBColor);

	for(int i = 0; i < 256; i++) {
		red[i] = green[i] = blue[i] = 0;
		hue[i] = luminance[i] = saturation[i] = 0;
	}

	for(int iy = 0; iy < b->height; iy++) {
		for(int ix = 0; ix < b->width; ix++) {
			if(GetRGB(b, ix, iy, rgb) == 0)
				return 0;
			red[rgb[0]]++;
			green[rgb[1]]++;
			blue[rgb[2]]++;
			hls = RGBtoHLS(RGB(rgb[0], rgb[1], rgb[2]));
			hue[GetRValue(hls)]++;
			luminance[GetGValue(hls)]++;
			saturation[GetBValue(hls)]++;
		}
	}
	return 1;
}

//
// ʂ̏o
//
static void
SetResult(
	Tcl_Interp *interp,
	char *color
)
{
	char num[100];
	int *rgb;

	if(!strcmp(color, "red"))
		rgb = red;
	else if(!strcmp(color, "green"))
		rgb = green;
	else if(!strcmp(color, "blue"))
		rgb = blue;
	else if(!strcmp(color, "hue"))
		rgb = hue;
	else if(!strcmp(color, "luminance"))
		rgb = luminance;
	else
		rgb = saturation;

	for(int i = 0; i < 256; i++) {
		sprintf(num, "%d", rgb[i]);
		Tcl_AppendElement(interp, num);
	}
}

//
// CountR}h
//
static int
Histogram_CountObjCmd(
	ClientData clientData,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj *CONST objv[]
)
{
	Tk_PhotoImageBlock piBlock;
	Tk_PhotoHandle hPhoto;

	if(objc != 2) {
		Tcl_WrongNumArgs(interp, 1, objv, "photo");
		return TCL_ERROR;
	}
	if((hPhoto  = Tk_FindPhoto(interp, Tcl_GetString(objv[1]))) == NULL){
		Tcl_AppendResult(interp, "photo image not found.", NULL);
		return TCL_ERROR;
	}
	Tk_PhotoGetImage(hPhoto, &piBlock);

	if(CountRGB(&piBlock) == 0) {
		Tcl_AppendResult(interp, "rgb data error.", NULL);
		return TCL_ERROR;
	}

	return TCL_OK;
}

//
// GetR}h
//
static int
Histogram_GetObjCmd(
	ClientData clientData,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj *CONST objv[]
)
{
	char *color;

	if(objc != 2) {
		Tcl_WrongNumArgs(interp, 1, objv, "{red, green, blue}");
		return TCL_ERROR;
	}
	color = Tcl_GetString(objv[1]);
	if(strcmp(color, "red") && strcmp(color, "green") && strcmp(color, "blue") && strcmp(color, "hue") && strcmp(color, "luminance") && strcmp(color, "saturation")) {
		Tcl_WrongNumArgs(interp, 1, objv, "{red, green, blue}");
		return TCL_ERROR;
	}

	SetResult(interp, color);

	return TCL_OK;
}

//
// R}h̒ǉ
//
static Tcl_Command
AddCommand(
	Tcl_Interp *interp,
	char *nameSpace,
	char *cmdName,
	Tcl_ObjCmdProc *cmdProc
)
{
	char *cmdPath;
	Tcl_DString dString;
	Tcl_Command cmdToken;

	Tcl_DStringInit(&dString);

	// Namespace::Command 쐬
	if (nameSpace != NULL) {
		Tcl_DStringAppend(&dString, nameSpace, -1);
	}
	Tcl_DStringAppend(&dString, "::", -1);
	Tcl_DStringAppend(&dString, cmdName, -1);

	cmdPath = Tcl_DStringValue(&dString);
	// o^̃`FbN
	cmdToken = Tcl_FindCommand(interp, cmdPath, (Tcl_Namespace *)NULL, 0);
	if (cmdToken != NULL) {
		Tcl_DStringFree(&dString);
		return cmdToken;
	}
	// R}h̓o^
	cmdToken = Tcl_CreateObjCommand(interp, cmdPath, cmdProc, NULL, NULL);
	Tcl_DStringFree(&dString);

	Tcl_Namespace *nsPtr;
	int dontResetList = 0;

	// Namespacẽ|C^擾
	nsPtr = Tcl_FindNamespace(interp, nameSpace, (Tcl_Namespace *)NULL, TCL_LEAVE_ERR_MSG);
	if (nsPtr == NULL) {
		return NULL;
	}
	// R}hGNX|[g
	if (Tcl_Export(interp, nsPtr, cmdName, dontResetList) != TCL_OK) {
		return NULL;
	}
	return cmdToken;
}

//
// gDLL̏
//
int
Histogram_Init(
	Tcl_Interp *interp
)
{
#ifdef USE_TCL_STUBS
	// Tcl Stub̏
	if (Tcl_InitStubs(interp, "8.1", 0) == NULL) {
		return TCL_ERROR;
	}
#endif // USE_TCL_STUBS
#ifdef USE_TK_STUBS
	// Tk Stub̏
	if (Tk_InitStubs(interp, "8.1", 0) == NULL) {
		return TCL_ERROR;
	}
#endif // USE_TK_STUBS

	// Namespace̐
	Tcl_Namespace *spacePtr = Tcl_CreateNamespace(interp, NAMESPACE, (ClientData)0, (Tcl_NamespaceDeleteProc *) NULL);
	if (spacePtr == NULL) {
		return TCL_ERROR;
	}

	// R}h̒ǉ
	AddCommand(interp, NAMESPACE, "count", Histogram_CountObjCmd);
	AddCommand(interp, NAMESPACE, "get", Histogram_GetObjCmd);

	// pbP[W̓o^ƃo[W̕ԋp
	return Tcl_PkgProvide(interp, PACKAGE, VERSION);
}
