#
# TkEngine Program V1.0
# by Satoshi Imai
#
wm title . TkEngine
wm deiconify .

catch {package require Img}

set delay 100
set run 0
set skip 0
set dir [file dirname [info script]]
cd $dir
set files [glob -- *.gif]

# init
set num 0
set images {}
while {![catch "image create photo pic$num \
		-file [lindex $files 0] -format {gif -index $num}"]} {
	lappend images pic$num
	incr num
}

# gui
pack [frame .f1]
button .f1.start -text Start -command start
button .f1.stop -text Stop -command stop
label .f1.label1 -text Delay:
scale .f1.delay -from 0 -to 100 -variable delay -orient horizontal
label .f1.label2 -text Skip:
tk_optionMenu .f1.skip skip 0 1 2 3 4 5 6 7 8 9 10
pack .f1.start .f1.stop .f1.label1 .f1.delay .f1.label2 .f1.skip -side left -padx 2
label .anim -image [lindex $images 0]
scrollbar .sh -command {.snap yview}
listbox .snap -width 12 -yscrollcommand {.sh set}
pack .anim -side left -fill both -expand 1
pack .snap .sh -side left -fill y

# menu
menu .popup -tearoff no
set sel [lindex $files 0]
foreach m $files {
	.popup add radiobutton -label $m -variable sel -value $m \
		-command "change $m" 
}
bind . <3> {tk_popup .popup %X %Y}

# start
proc start {} {
	global run num images delay skip loop nsnap
	if {$run == 1} {return}
	set run 1
	set idx 0
	.snap delete 0 end
	set nsnap 0
	settimer
	while {$run} {
		set idx [expr $idx + $skip + 1]
		if {$idx >= $num} {set idx 0}
		.anim configure -image [lindex $images $idx]
		update
		after $delay
		incr loop
	}
}

# stop
proc stop {} {
	global run
	killtimer
	set run 0
}

# change
proc change {file} {
	global num files images dir
	set save_cur [. cget -cursor]
	. configure -cursor watch
	update
	foreach p [image names] {
		image delete $p
	}
	set num 0
	set images {}
	while {![catch "image create photo pic$num \
		-file $file -format {gif -index $num}"]} {
		lappend images pic$num
		incr num
	}
	.anim configure -image [lindex $images 0]
	. configure -cursor $save_cur
	update
}

# set timer
proc settimer {} {
	global loop timerid
	set loop 0
	set timerid [after 1000 snap]
}

# snap
proc snap {} {
	global loop nsnap
	incr nsnap
	if {$nsnap <= 100} {
		.snap insert end "$loop frames/sec."
		.snap see end
		settimer
	}
}

# kill timer
proc killtimer {} {
	global timerid
	after cancel $timerid
}
